/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.componente;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Compensacion;
import ec.gob.sri.dimm.ats.ui.asistentes.modifiers.ventas.CompensacionCellModifier;
import ec.gob.sri.dimm.ats.ui.componente.OperacionCompositeCompensaciones;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class CompensacionComposite
extends Composite {
    private static final String NO_SE_PUEDE_ELIMINAR_LA_COMPENSACION = "No se puede eliminar la compensaci\u00f3n";
    private Combo combo;
    private ComboViewer cvCompensaciones;
    private Label lblCompensaciones;
    private Table tblCompensaciones;
    private TableColumn tblclmnDescripcin;
    private TableColumn tblclmnMonto;
    private TableViewer tViewerCompensaciones;
    private ModeloValores modeloValores;
    private Button btnEliminarCompensacion;
    private ObjetoModelo modeloDatos;
    private PaginaAsistente paginaAsistente;
    private OperacionCompositeCompensaciones funcionSeleccionar;
    private OperacionCompositeCompensaciones funcionEliminar;
    private Compensacion compensacionSelecccionada;

    public CompensacionComposite(Composite container, int style, ModeloValores modelovalores, ObjetoModelo modeloDatos, PaginaAsistente paginaAsistente) {
        super(container, style);
        this.modeloValores = modelovalores;
        this.modeloDatos = modeloDatos;
        this.paginaAsistente = paginaAsistente;
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(16384, 4, false, false, 4, 1));
        this.lblCompensaciones = new Label((Composite)this, 0);
        GridData gd_lblCompensaciones = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblCompensaciones.widthHint = 180;
        this.lblCompensaciones.setLayoutData((Object)gd_lblCompensaciones);
        this.lblCompensaciones.setSize(91, 15);
        this.lblCompensaciones.setText("Compensaciones");
        this.createComboCompensaciones();
        String[] columnNames = new String[]{"Descripcion", "Monto"};
        this.tViewerCompensaciones = new TableViewer((Composite)this, 67584);
        this.tViewerCompensaciones.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CompensacionComposite.this.compensacionSelecccionada = (Compensacion)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
            }
        });
        this.tViewerCompensaciones.setColumnProperties(columnNames);
        CellEditor[] editors = new CellEditor[columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.tViewerCompensaciones.getTable());
        ((Text)textEditor.getControl()).setTextLimit(15);
        editors[1] = textEditor;
        this.tViewerCompensaciones.setCellEditors(editors);
        this.tViewerCompensaciones.setCellModifier((ICellModifier)new CompensacionCellModifier(modeloDatos, paginaAsistente));
        this.tblCompensaciones = this.tViewerCompensaciones.getTable();
        this.tblCompensaciones.setSize(new Point(0, 50));
        this.tblCompensaciones.setLinesVisible(true);
        GridData gd_tblCompensaciones = new GridData(4, 4, false, false, 2, 1);
        gd_tblCompensaciones.heightHint = 50;
        gd_tblCompensaciones.widthHint = 463;
        this.tblCompensaciones.setLayoutData((Object)gd_tblCompensaciones);
        this.tblCompensaciones.setSize(564, 47);
        this.tblCompensaciones.setHeaderVisible(true);
        this.tblclmnDescripcin = new TableColumn(this.tblCompensaciones, 0);
        this.tblclmnDescripcin.setWidth(250);
        this.tblclmnDescripcin.setText("Descripci\u00f3n");
        this.tblclmnMonto = new TableColumn(this.tblCompensaciones, 0);
        this.tblclmnMonto.setWidth(120);
        this.tblclmnMonto.setText("Monto");
        this.btnEliminarCompensacion = new Button((Composite)this, 0);
        this.btnEliminarCompensacionClicked();
        this.btnEliminarCompensacion.setText("Eliminar Compensaci\u00f3n");
        new Label((Composite)this, 0);
        this.initDataBindings();
    }

    private void createComboCompensaciones() {
        this.cvCompensaciones = new ComboViewer((Composite)this, 8);
        this.combo = this.cvCompensaciones.getCombo();
        GridData gdComboCompensaciones = new GridData(4, 0x1000000, false, false, 1, 1);
        gdComboCompensaciones.widthHint = 250;
        this.combo.setLayoutData((Object)gdComboCompensaciones);
        this.seleccionCompensacionClicked();
    }

    private void seleccionCompensacionClicked() {
        this.cvCompensaciones.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor compensacionSeleccionada = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (compensacionSeleccionada != null) {
                    Compensacion nuevaCompensacion = new Compensacion();
                    nuevaCompensacion.setDescripcionCompensacion(compensacionSeleccionada.getNombre());
                    nuevaCompensacion.setCodigo((String)compensacionSeleccionada.getValor());
                    CompensacionComposite.this.funcionSeleccionar.operar(nuevaCompensacion);
                }
            }
        });
    }

    private void btnEliminarCompensacionClicked() {
        this.btnEliminarCompensacion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompensacionComposite.this.compensacionSelecccionada != null) {
                    CompensacionComposite.this.funcionEliminar.operar(CompensacionComposite.this.compensacionSelecccionada);
                    CompensacionComposite.this.compensacionSelecccionada = null;
                } else {
                    CompensacionComposite.this.paginaAsistente.mostrarError(CompensacionComposite.NO_SE_PUEDE_ELIMINAR_LA_COMPENSACION);
                }
            }
        });
    }

    public void setFuncionSeleccionar(OperacionCompositeCompensaciones funcionSeleccionar) {
        this.funcionSeleccionar = funcionSeleccionar;
    }

    public OperacionCompositeCompensaciones getFuncionEliminar() {
        return this.funcionEliminar;
    }

    public void setFuncionEliminar(OperacionCompositeCompensaciones funcionEliminar) {
        this.funcionEliminar = funcionEliminar;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvCompensaciones.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.cvCompensaciones.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList modeloValoresCompensacionesObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"compensaciones");
        this.cvCompensaciones.setInput((Object)modeloValoresCompensacionesObserveList);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap[] observeMaps = BeansObservables.observeMaps((IObservableSet)listContentProvider_2.getKnownElements(), Compensacion.class, (String[])new String[]{"descripcionCompensacion", "monto"});
        this.tViewerCompensaciones.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.tViewerCompensaciones.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList modeloDatosCompensacionesObserveList = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloDatos, (String)"compensaciones");
        this.tViewerCompensaciones.setInput((Object)modeloDatosCompensacionesObserveList);
        return bindingContext;
    }
}

